-- name: [CS] Chaos
-- description: The silleh\n\n\\#ff7777\\This Pack requires Character Select\nto use as a Library!

local E_MODEL_CHAOS_GOWN = smlua_model_util_get_id("chaos_normal_geo")
local E_MODEL_CHAOS_GOWN_INFLATED = smlua_model_util_get_id("chaos_gown_inflated_geo")
local E_MODEL_CHAOS_PLUMBER = smlua_model_util_get_id("chaos_plumber_geo")
local E_MODEL_CHAOS_PLUMBER_INFLATED = smlua_model_util_get_id("chaos_plumber_inflated_geo")
local E_MODEL_CHAOS_HORNYTEE = smlua_model_util_get_id("chaos_hornytee_geo")
local E_MODEL_CHAOS_HORNYTEE_INFLATED = smlua_model_util_get_id("chaos_hornytee_inflated_geo")
local E_MODEL_CHAOS_RETROTEE = smlua_model_util_get_id("chaos_retrotee_geo")
local E_MODEL_CHAOS_RETROTEE_INFLATED = smlua_model_util_get_id("chaos_retrotee_inflated_geo")
local E_MODEL_CHAOS_2005 = smlua_model_util_get_id("chaos_2005_geo")
local E_MODEL_CHAOS_2005_INFLATED = smlua_model_util_get_id("chaos_2005_inflated_geo")
local E_MODEL_CHAOS_70S = smlua_model_util_get_id("chaos_70s_geo")
local E_MODEL_CHAOS_70S_INFLATED = smlua_model_util_get_id("chaos_70s_inflated_geo")
local E_MODEL_CHAOS_PEAM = smlua_model_util_get_id("chaos_peam_geo")
local E_MODEL_CHAOS_PEAM_INFLATED = smlua_model_util_get_id("chaos_peam_inflated_geo")
local E_MODEL_CHAOS_PLOON = smlua_model_util_get_id("chaos_ploon_geo")
local E_MODEL_CHAOS_PLOON_INFLATED = smlua_model_util_get_id("chaos_ploon_inflated_geo")
local E_MODEL_CHAOS_SORETRO = smlua_model_util_get_id("chaos_retro_geo")
local E_MODEL_CHAOS_SORETRO_INFLATED = smlua_model_util_get_id("chaos_retro_inflated_geo")

local E_MODEL_YOURDIDIT = smlua_model_util_get_id("yourdidit_geo")

local TEX_CHAOS_ICON = get_texture_info("chaos-icon")
local TEX_CHAOS_ICON_BERRY = get_texture_info("chaos-icon-horny")
local TEX_CHAOS_ICON_HAT = get_texture_info("chaos-icon-plumber")
local TEX_CHAOS_ICON_PEAM = get_texture_info("chaos-icon-peam")
local TEX_CHAOS_ICON_RETRO = get_texture_info("chaos-icon-retro")

SWAP_SND = audio_sample_load("swap.ogg")

local chaosBloatActions = {
    [ACT_WALKING] = true,
    [ACT_IDLE] = true,
	[ACT_CROUCHING] = true,
    [ACT_CROUCH_SLIDE] = true,
    [ACT_TRIPLE_JUMP_LAND] = true,
	[ACT_DIVE_SLIDE] = true,
}

local chaosBloatActionsAIR = {
    [ACT_JUMP] = true,
    [ACT_DOUBLE_JUMP] = true,
    [ACT_TRIPLE_JUMP] = true,
    [ACT_LONG_JUMP] = true,
    [ACT_BACKFLIP] = true,
    [ACT_SIDE_FLIP] = true,
    [ACT_WALL_KICK_AIR] = true,
    [ACT_DIVE] = true,
    [ACT_WATER_JUMP] = true,
    [ACT_STEEP_JUMP] = true,
    [ACT_LAVA_BOOST] = true,
	[ACT_SHOT_FROM_CANNON] = true,
}

INFLATE_SND = audio_sample_load("inflate.ogg")
BERRY_SND = audio_sample_load("berrification.ogg")
PLOON_SND = audio_sample_load("ploon.ogg")
RETROINF_SND = audio_sample_load("itemrespawn.ogg")

BURST_SND = audio_sample_load("pop.ogg")
BERRYBURST_SND = audio_sample_load("burst.ogg")
SNESBURST_SND = audio_sample_load("yis.ogg")
RETROBURST_SND = audio_sample_load("enemykill.ogg")

local speed = 0

local character_edit = _G.charSelect.character_edit


local TEXT_MOD_NAME = "Chaos"

local VOICETABLE_CHAOS = {
    [CHAR_SOUND_ATTACKED] = 'chaos-what.ogg',
	[CHAR_SOUND_COUGHING1] = 'chaos-burn.ogg',
    [CHAR_SOUND_COUGHING2] = 'chaos-burn.ogg',
    [CHAR_SOUND_COUGHING3] = 'chaos-burn.ogg',
	[CHAR_SOUND_EEUH] = 'chaos-punch.ogg',
    [CHAR_SOUND_HRMM] = 'chaos-punch.ogg',
    [CHAR_SOUND_DOH] = 'chaos-ouch.ogg',
    [CHAR_SOUND_DROWNING] = 'chaos-death.ogg',
    [CHAR_SOUND_DYING] = 'chaos-death.ogg',
    [CHAR_SOUND_GROUND_POUND_WAH] = 'chaos-teehee.ogg',
    [CHAR_SOUND_WAAAOOOW] = 'chaos-fall.ogg',
    [CHAR_SOUND_HAHA] = {'chaos-jingle1.ogg','chaos-jingle2.ogg','chaos-jingle3.ogg','chaos-jingle4.ogg'},
    [CHAR_SOUND_HAHA_2] = 'chaos-teehee.ogg',
    [CHAR_SOUND_HERE_WE_GO] = {'chaos-win1.ogg','chaos-win2.ogg','chaos-win3.ogg','chaos-win4.ogg'},
    [CHAR_SOUND_HOOHOO] = 'chaos-hoohoo.ogg',
    [CHAR_SOUND_MAMA_MIA] = 'chaos-teehee.ogg',
    [CHAR_SOUND_ON_FIRE] = 'chaos-burn.ogg',
    [CHAR_SOUND_OOOF] = 'chaos-pain.ogg',
    [CHAR_SOUND_UH] = 'chaos-pain.ogg',
    [CHAR_SOUND_UH2] = 'chaos-pain.ogg',
    [CHAR_SOUND_OOOF2] = 'chaos-pain.ogg',
    [CHAR_SOUND_LETS_A_GO] = 'chaos-haha.ogg',
    [CHAR_SOUND_PUNCH_HOO] = 'chaos-kick.ogg',
    [CHAR_SOUND_PUNCH_WAH] = 'chaos-punch.ogg',
    [CHAR_SOUND_PUNCH_YAH] = 'chaos-punch.ogg',
    [CHAR_SOUND_SO_LONGA_BOWSER] = 'chaos-bowser.ogg',
    [CHAR_SOUND_TWIRL_BOUNCE] = 'chaos-teehee.ogg',
    [CHAR_SOUND_WAH2] = 'chaos-kick.ogg',
    [CHAR_SOUND_WHOA] = 'chaos-punch.ogg',
    [CHAR_SOUND_YAHOO] = {'chaos-yay1.ogg', 'chaos-yay2.ogg', 'chaos-yay3.ogg'},
    [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = {'chaos-yay1.ogg', 'chaos-yay2.ogg', 'chaos-yay3.ogg'},
    [CHAR_SOUND_YAH_WAH_HOO] = {'chaos-jump1.ogg', 'chaos-jump2.ogg', 'chaos-jump3.ogg', 'chaos-jump4.ogg'},
}

local CAPTABLE_CHAO = {
    normal = smlua_model_util_get_id("chaos_hat_geo"),
    wing = smlua_model_util_get_id("chaos_hat_geo"),
    metal = smlua_model_util_get_id("chaos_hat_geo"),
}

local CAPTABLE_PEAM = {
    normal = smlua_model_util_get_id("chaos_hat_peam_geo"),
    wing = smlua_model_util_get_id("chaos_hat_peam_geo"),
    metal = smlua_model_util_get_id("chaos_hat_peam_geo"),
}

local CAPTABLE_PLUG = {
    normal = smlua_model_util_get_id("buttplug_geo"),
    wing = smlua_model_util_get_id("buttplug_geo"),
    metal = smlua_model_util_get_id("buttplug_geo"),
}

if _G.charSelectExists then
    CT_CHAOS = _G.charSelect.character_add("Chaos", {"The silleh~", "", "< Outfit:  Fool's Gown >", "Use D-pad L/R to Switch Outfits"}, "ChaoThix", {r = 50, g = 255, b = 00}, E_MODEL_CHAOS_GOWN, CT_MARIO, TEX_CHAOS_ICON)

    -- the following must be hooked for each character added
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_GOWN, VOICETABLE_CHAOS)
	_G.charSelect.character_add_voice(E_MODEL_CHAOS_GOWN_INFLATED, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_PLUMBER, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_PLUMBER_INFLATED, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_HORNYTEE, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_HORNYTEE_INFLATED, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_RETROTEE, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_RETROTEE_INFLATED, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_2005, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_2005_INFLATED, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_70S, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_70S_INFLATED, VOICETABLE_CHAOS)
	_G.charSelect.character_add_voice(E_MODEL_CHAOS_PEAM, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_PEAM_INFLATED, VOICETABLE_CHAOS)
	_G.charSelect.character_add_voice(E_MODEL_CHAOS_PLOON, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_PLOON_INFLATED, VOICETABLE_CHAOS)
	_G.charSelect.character_add_voice(E_MODEL_CHAOS_SORETRO, VOICETABLE_CHAOS)
    _G.charSelect.character_add_voice(E_MODEL_CHAOS_SORETRO_INFLATED, VOICETABLE_CHAOS)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_GOWN, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_GOWN_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_PLUMBER, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_PLUMBER_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_HORNYTEE, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_HORNYTEE_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_RETROTEE, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_RETROTEE_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_2005, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_2005_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_70S, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_70S_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_PEAM, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_PEAM_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_PLOON, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_PLOON_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_SORETRO, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_celebration_star(E_MODEL_CHAOS_SORETRO_INFLATED, E_MODEL_YOURDIDIT, nil)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_PLUMBER, CAPTABLE_CHAO)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_PEAM, CAPTABLE_PEAM)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_PLUMBER_INFLATED, CAPTABLE_CHAO)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_PLOON, CAPTABLE_CHAO)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_PLOON_INFLATED, CAPTABLE_CHAO)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_PEAM_INFLATED, CAPTABLE_PEAM)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_GOWN, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_GOWN_INFLATED, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_HORNYTEE, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_HORNYTEE_INFLATED, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_RETROTEE, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_RETROTEE_INFLATED, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_2005, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_2005_INFLATED, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_70S, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_70S_INFLATED, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_SORETRO, CAPTABLE_PLUG)
	_G.charSelect.character_add_caps(E_MODEL_CHAOS_SORETRO_INFLATED, CAPTABLE_PLUG)

    hook_event(HOOK_CHARACTER_SOUND, function (m, sound)
        if _G.charSelect.character_get_voice(m) == VOICETABLE_CHAOS then return _G.charSelect.voice.sound(m, sound) end
    end)
    hook_event(HOOK_MARIO_UPDATE, function (m)
        if _G.charSelect.character_get_voice(m) == VOICETABLE_CHAOS then return _G.charSelect.voice.snore(m) end
    end)
else
    djui_popup_create("\\#ffffdc\\\n"..TEXT_MOD_NAME.."\nRequires the Character Select Mod\nto use as a Library!\n\nPlease turn on the Character Select Mod", 6)
end

chaosAlt = 1
local chaosAltTable = {
    {outfitName = "Fool's Gown", outfitModel = E_MODEL_CHAOS_GOWN, inflatedModel = E_MODEL_CHAOS_GOWN_INFLATED, inflateSFX = INFLATE_SND, popSFX = BURST_SND, outfitIcon = TEX_CHAOS_ICON},
	{outfitName = "Pipe Crawler", outfitModel = E_MODEL_CHAOS_PLUMBER, inflatedModel = E_MODEL_CHAOS_PLUMBER_INFLATED, inflateSFX = INFLATE_SND, popSFX = BURST_SND, outfitIcon = TEX_CHAOS_ICON_HAT},
	{outfitName = "P Balloon Suit", outfitModel = E_MODEL_CHAOS_PLOON, inflatedModel = E_MODEL_CHAOS_PLOON_INFLATED, inflateSFX = PLOON_SND, popSFX = SNESBURST_SND, outfitIcon = TEX_CHAOS_ICON_HAT},
	{outfitName = "Burlap Overalls", outfitModel = E_MODEL_CHAOS_PEAM, inflatedModel = E_MODEL_CHAOS_PEAM_INFLATED, inflateSFX = INFLATE_SND, popSFX = BURST_SND, outfitIcon = TEX_CHAOS_ICON_PEAM},
	{outfitName = "Retro Tee", outfitModel = E_MODEL_CHAOS_RETROTEE, inflatedModel = E_MODEL_CHAOS_RETROTEE_INFLATED, inflateSFX = INFLATE_SND, popSFX = BURST_SND, outfitIcon = TEX_CHAOS_ICON},
	{outfitName = "Horny Tee", outfitModel = E_MODEL_CHAOS_HORNYTEE, inflatedModel = E_MODEL_CHAOS_HORNYTEE_INFLATED, inflateSFX = BERRY_SND, popSFX = BERRYBURST_SND, outfitIcon = TEX_CHAOS_ICON_BERRY},
	{outfitName = "2005 Tracksuit", outfitModel = E_MODEL_CHAOS_2005, inflatedModel = E_MODEL_CHAOS_2005_INFLATED, inflateSFX = BERRY_SND, popSFX = BERRYBURST_SND, outfitIcon = TEX_CHAOS_ICON_BERRY},
	{outfitName = "70s Winterwear", outfitModel = E_MODEL_CHAOS_70S, inflatedModel = E_MODEL_CHAOS_70S_INFLATED, inflateSFX = BERRY_SND, popSFX = BERRYBURST_SND, outfitIcon = TEX_CHAOS_ICON_BERRY},
	{outfitName = "SO RETRO!!!!!", outfitModel = E_MODEL_CHAOS_SORETRO, inflatedModel = E_MODEL_CHAOS_SORETRO_INFLATED, inflateSFX = RETROINF_SND, popSFX = RETROBURST_SND, outfitIcon = TEX_CHAOS_ICON_RETRO},
}

local function update_chaos_edit(intAdd)
    chaosAlt = chaosAlt + intAdd
    if chaosAlt > #chaosAltTable then chaosAlt = 1 end
    if chaosAlt < 1 then chaosAlt = #chaosAltTable end
    _G.charSelect.character_edit(CT_CHAOS, nil, {"The silleh~", "", "< Outfit:  "..chaosAltTable[chaosAlt].outfitName.." >", "Use D-pad L/R to Switch Outfits"}, nil, nil, chaosAltTable[chaosAlt].outfitModel, CT_MARIO, chaosAltTable[chaosAlt].outfitIcon)
end

local function mario_update(m)
    if m.playerIndex ~= 0 then return end
    if _G.charSelect.is_menu_open() then
        if _G.charSelect.character_get_current_number() == CT_CHAOS then
            if (_G.charSelect.controller.buttonPressed & R_JPAD) ~= 0 then
                update_chaos_edit(1)
				set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_SPARKLES), 0)
				audio_sample_play(SWAP_SND, gMarioStates[0].pos, 1.0)
            end
            if (_G.charSelect.controller.buttonPressed & L_JPAD) ~= 0 then
                update_chaos_edit(-1)
				set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_SPARKLES), 0)
				audio_sample_play(SWAP_SND, gMarioStates[0].pos, 1.0)
            end
        end
    end
end

hook_event(HOOK_MARIO_UPDATE, mario_update)

-----------------------
-- ROLLING --
-----------------------

ACT_CHAOS_BALLOON_ROLL= allocate_mario_action(ACT_GROUP_MOVING | ACT_FLAG_MOVING | ACT_FLAG_ATTACKING | ACT_FLAG_RIDING_SHELL)
ACT_CHAOS_BALLOON_JUMP = allocate_mario_action(ACT_GROUP_AIRBORNE | ACT_FLAG_ALLOW_VERTICAL_WIND_ACTION | ACT_FLAG_MOVING | ACT_FLAG_ATTACKING | ACT_FLAG_RIDING_SHELL)
ACT_CHAOS_BALLOON_REBOUND  = allocate_mario_action(ACT_GROUP_AIRBORNE | ACT_FLAG_AIR | ACT_FLAG_RIDING_SHELL)

--- @param m MarioState
local function act_chaos_balloon_roll(m)


    -- physics
    local stepResult = perform_ground_step(m)
    if stepResult == GROUND_STEP_HIT_WALL then
        if m.wall.object == nil or m.wall.object.oInteractType & (INTERACT_BREAKABLE) == 0 then
            return chaos_rebound(m, m.forwardVel * -1, 30)
        end
    elseif stepResult == GROUND_STEP_LEFT_GROUND then
        m.action = ACT_CHAOS_BALLOON_JUMP
    end

	apply_slope_accel(m)
	set_mario_particle_flags(m, (ACTIVE_PARTICLE_SHALLOW_WATER_WAVE | ACTIVE_PARTICLE_DUST), 0)
	
	if (m.input & INPUT_Z_DOWN) ~= 0 then
        if m.forwardVel > 0 then
		m.forwardVel = m.forwardVel - 1
		end
        if m.forwardVel < 0 then
		m.forwardVel = m.forwardVel + 1
		end
		set_mario_animation(m, CHAR_ANIM_WATER_FORWARD_KB)
	else
		if m.forwardVel < 50 then
		m.forwardVel = m.forwardVel + 1
		end
		set_mario_animation(m, CHAR_ANIM_FORWARD_SPINNING)
    end

    -- jump
    if (m.input & INPUT_A_PRESSED) ~= 0 and (m.input & INPUT_Z_DOWN) == 0 then
		m.vel.y = 50
        set_jumping_action(m, ACT_CHAOS_BALLOON_JUMP, 0)
		set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE), 0)
		play_sound(SOUND_ACTION_BOUNCE_OFF_OBJECT, m.marioObj.header.gfx.cameraToObject)
    end
	
	if (m.input & INPUT_B_PRESSED) ~= 0 then
		m.vel.y = 25
        set_jumping_action(m, ACT_FORWARD_ROLLOUT, 0)
		set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
		audio_sample_play(chaosAltTable[chaosAlt].popSFX, gMarioStates[0].pos, 1.0)
		set_camera_shake_from_point(SHAKE_POS_MEDIUM, m.pos.x, m.pos.y, m.pos.z)
    end

    m.actionTimer = m.actionTimer + 1
    return 0

end

function act_chaos_balloon_jump(m)

    -- physics
    local stepResult = perform_air_step(m, 0)
    update_air_without_turn(m)
    set_mario_animation(m, CHAR_ANIM_WATER_FORWARD_KB)
    if stepResult == AIR_STEP_HIT_WALL then
       if m.wall.object == nil or m.wall.object.oInteractType & (INTERACT_BREAKABLE) == 0 then
            return chaos_rebound(m, m.forwardVel * -1, 30)
        end
    elseif stepResult == AIR_STEP_LANDED then
				speed = m.forwardVel
                m.action = ACT_CHAOS_BALLOON_ROLL
				set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
				play_sound(SOUND_ACTION_TERRAIN_HEAVY_LANDING, m.marioObj.header.gfx.cameraToObject)
				set_camera_shake_from_hit(SHAKE_GROUND_POUND)
				m.squishTimer = 5
    end

	if (m.input & INPUT_B_PRESSED) ~= 0 then
		m.vel.y = 25
        set_jumping_action(m, ACT_FORWARD_ROLLOUT, 0)
		set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
		audio_sample_play(chaosAltTable[chaosAlt].popSFX, gMarioStates[0].pos, 1.0)
		set_camera_shake_from_point(SHAKE_POS_MEDIUM, m.pos.x, m.pos.y, m.pos.z)
    end

    -- slide kick
    if (m.input & INPUT_Z_DOWN) ~= 0 then
        m.vel.y = m.vel.y - 8
    end
	
	m.peakHeight = m.pos.y

    m.actionTimer = m.actionTimer + 1
    return 0
end

function act_chaos_balloon_rebound(m)

	m.peakHeight = m.pos.y
	
	if (m.input & INPUT_B_PRESSED) ~= 0 then
		m.vel.y = 25
        set_jumping_action(m, ACT_BACKWARD_ROLLOUT, 0)
		set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE | PARTICLE_HORIZONTAL_STAR), 0)
		audio_sample_play(chaosAltTable[chaosAlt].popSFX, gMarioStates[0].pos, 1.0)
		set_camera_shake_from_point(SHAKE_POS_MEDIUM, m.pos.x, m.pos.y, m.pos.z)
    end
	
    -- physics
    local stepResult = perform_air_step(m, 0)
    update_air_without_turn(m)
    set_mario_animation(m, CHAR_ANIM_BACKWARDS_WATER_KB)
    if stepResult == AIR_STEP_LANDED then
      set_mario_action(m, ACT_CHAOS_BALLOON_ROLL, 0)
	  speed = 0
    end
    return 0
end

function chaos_rebound(m, VelF, VelY)
    mario_set_forward_vel(m, VelF)
    set_camera_shake_from_point(SHAKE_POS_SMALL, m.pos.x, m.pos.y, m.pos.z)
    m.vel.y = VelY
    set_mario_action(m, ACT_CHAOS_BALLOON_REBOUND, 0)
	m.vel.y = 25
    m.particleFlags = m.particleFlags | PARTICLE_VERTICAL_STAR
    play_sound(SOUND_ACTION_HIT, m.marioObj.header.gfx.cameraToObject)
    return 0
end

function convert_s16(num)
    local min = -32768
    local max = 32767
    while (num < min) do
        num = max + (num - min)
    end
    while (num > max) do
        num = min + (num - max)
    end
    return num
end


--- @param m MarioState
function chaos_update(m)
    if (m.controller.buttonDown & X_BUTTON) ~= 0 and m.prevAction ~= ACT_CHAOS_BALLOON_ROLL and chaosBloatActions[m.action] then
		audio_sample_play(chaosAltTable[chaosAlt].inflateSFX, gMarioStates[0].pos, 1.0)
		set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE), 0)
		speed = m.forwardVel
        set_mario_action(m, ACT_CHAOS_BALLOON_ROLL, 0)
	end
	
    if (m.controller.buttonDown & X_BUTTON) ~= 0 and m.prevAction ~= ACT_CHAOS_BALLOON_ROLL and chaosBloatActionsAIR[m.action] then
		audio_sample_play(chaosAltTable[chaosAlt].inflateSFX, gMarioStates[0].pos, 1.0)
		set_mario_particle_flags(m, (PARTICLE_MIST_CIRCLE), 0)
		speed = m.forwardVel
        set_mario_action(m, ACT_CHAOS_BALLOON_JUMP, 0)
	end
	
	if ( (gMarioStates[0].action == ACT_CHAOS_BALLOON_ROLL or gMarioStates[0].action == ACT_CHAOS_BALLOON_JUMP or gMarioStates[0].action == ACT_CHAOS_BALLOON_REBOUND )) and chaosAltTable[chaosAlt].inflatedModel ~= nil then
        _G.charSelect.character_edit(CT_CHAOS, nil, nil, nil, nil, chaosAltTable[chaosAlt].inflatedModel)
     else
        _G.charSelect.character_edit(CT_CHAOS, nil, nil, nil, nil, chaosAltTable[chaosAlt].outfitModel)
    end
		
	if m.action == ACT_CHAOS_BALLOON_ROLL then
		m.faceAngle.y = m.intendedYaw - approach_s32(convert_s16(m.intendedYaw - m.faceAngle.y), 0, 0x400, 0x400)
	end

end

hook_mario_action(ACT_CHAOS_BALLOON_ROLL, act_chaos_balloon_roll)
hook_mario_action(ACT_CHAOS_BALLOON_JUMP, act_chaos_balloon_jump)
hook_mario_action(ACT_CHAOS_BALLOON_REBOUND, act_chaos_balloon_rebound)

local function on_character_select_load()
    _G.charSelect.character_hook_moveset(CT_CHAOS, HOOK_MARIO_UPDATE, chaos_update)
end


hook_event(HOOK_ON_MODS_LOADED, on_character_select_load)


local scale = 1     -- Reduced scale for smaller text
local x = 10         -- X position for the speed display (adjusted for left padding)
local y = 27         -- Y position for the speed display (set to 850)
local background = 0.0 -- Background color (0.0 for transparent)

function hud_speed()
    local m = gMarioStates[0]  -- Get Mario's state
	if obj_get_first_with_behavior_id(id_bhvActSelector) ~= nil then return end  -- Hides HUD during star select
	if gNetworkPlayers[0].currActNum == 99 then return end  -- Hides HUD during Act 99, aka the credits
    djui_hud_set_font(FONT_HUD)
	djui_hud_set_resolution(RESOLUTION_N64)
    screenWidth = djui_hud_get_screen_width()  -- Width of the screen
    screenHeight = djui_hud_get_screen_height()  -- Height of the screen
    djui_hud_set_color(255 * background, 0, 0, 128)  -- Set background color
    djui_hud_set_color(255, 255, 255, 255)  -- Set text color

    if (m.action == ACT_CHAOS_BALLOON_ROLL or m.action == ACT_CHAOS_BALLOON_JUMP or m.action == ACT_CHAOS_BALLOON_REBOUND ) then
        -- Display "SPD" followed by the horizontal speed formatted to one digit
        djui_hud_print_text(string.format("SPD - %d", math.floor(m.forwardVel)), screenWidth / x, screenHeight - y, scale)
    end
end

function on_hud_render()
    hud_speed()  -- Call the speed display function
end

hook_event(HOOK_ON_HUD_RENDER_BEHIND, on_hud_render)